/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public class MotifGraphicsUtils
implements SwingConstants {
    public static final Font controlFont = new Font("Dialog", 0, 12);
    public static Color control = new Color(192, 192, 192);
    public static Color controlLight = new Color(231, 231, 231);
    public static Color controlShadow = new Color(102, 102, 102);
    public static Color controlLightShadow = new Color(155, 155, 155);
    public static Color controlHighlight = Color.white;
    public static Color controlDisabled = new Color(117, 117, 117);
    public static Color controlBlack = Color.black;
    public static Color controlWhite = Color.white;
    public static final Color gray231 = new Color(231, 231, 231);
    public static final Color gray153 = new Color(153, 153, 153);
    public static final Color gray102 = new Color(102, 102, 102);

    static void drawButtonBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setColor(controlWhite);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics.setColor(controlLight);
            graphics.drawLine(n, n2, n + n3 - 3, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 4);
            graphics.setColor(controlLightShadow);
            graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
            graphics.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + 1);
            graphics.drawLine(n + n3 - 3, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
            graphics.setColor(controlShadow);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + 1);
            graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
            return;
        }
        graphics.setColor(controlWhite);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        graphics.setColor(controlLight);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + 3);
        graphics.setColor(controlLightShadow);
        graphics.drawLine(n + 2, n2 + 1, n + n3 - 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 2);
        graphics.drawLine(n3 - 1, n2, n + n3 - 1, n2);
        graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
        graphics.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
        graphics.setColor(controlShadow);
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
    }

    static void drawRaisedScrollButtonBezel(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2 + 1, n, n6 - 3);
        graphics.drawLine(n + 1, n2, n5 - 3, n2);
        graphics.setColor(gray231);
        MotifGraphicsUtils.drawPoint(graphics, n, n2);
        MotifGraphicsUtils.drawPoint(graphics, n, n6 - 2);
        MotifGraphicsUtils.drawPoint(graphics, n5 - 2, n2);
        graphics.setColor(gray153);
        MotifGraphicsUtils.drawPoint(graphics, n5 - 1, n2);
        MotifGraphicsUtils.drawPoint(graphics, n5 - 1, n6 - 1);
        MotifGraphicsUtils.drawPoint(graphics, n, n6 - 1);
        graphics.setColor(gray102);
        graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 2);
        graphics.drawLine(n + 1, n6 - 1, n5 - 2, n6 - 1);
    }

    static void drawLoweredScrollButtonBezel(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.setColor(gray153);
        graphics.drawLine(n, n6 - 1, n5 - 1, n6 - 1);
        graphics.drawLine(n5 - 1, n2, n5 - 1, n6 - 2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n, n2, n5 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n6 - 2);
    }

    static void drawPoint(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, n2, n, n2);
    }

    static void drawTiledIcon(Component component, Icon icon, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = graphics.getClipBounds();
        int n5 = icon.getIconWidth();
        int n6 = icon.getIconHeight();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        graphics2.setClip(n, n2, n3, n4);
        int n7 = n > rectangle.x ? n : n + n5 * ((rectangle.x - n) / n5);
        int n8 = n + n3 < rectangle.x + rectangle.width ? n + n3 : rectangle.x + rectangle.width;
        int n9 = n2 > rectangle.y ? n2 : n2 + n6 * ((rectangle.y - n2) / n6);
        int n10 = n2 + n4 < rectangle.y + rectangle.height ? n2 + n4 : rectangle.y + rectangle.height;
        n = n7;
        while (n < n8) {
            n2 = n9;
            while (n2 < n10) {
                icon.paintIcon(component, graphics2, n, n2);
                n2 += n6;
            }
            n += n5;
        }
        graphics2.dispose();
    }

    public static void drawGroove(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(controlShadow);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(controlWhite);
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    public static void drawStringInRect(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (graphics.getFont() == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics == null) {
            return;
        }
        if (n5 == 0) {
            int n7 = fontMetrics.stringWidth(string);
            if (n7 > n3) {
                n7 = n3;
            }
            n6 = n + (n3 - n7) / 2;
        } else if (n5 == 4) {
            int n8 = fontMetrics.stringWidth(string);
            if (n8 > n3) {
                n8 = n3;
            }
            n6 = n + n3 - n8;
        } else {
            n6 = n;
        }
        int n9 = (n4 - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (n9 < 0) {
            n9 = 0;
        }
        int n10 = n2 + n4 - n9 - fontMetrics.getDescent();
        graphics.drawString(string, n6, n10);
    }

    public static void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        ButtonModel buttonModel = jMenuItem.getModel();
        Dimension dimension = jMenuItem.getSize();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle();
        Font font = graphics.getFont();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(UIManager.getFont((Object)"MenuItem.acceleratorFont"));
        if (jComponent.isOpaque()) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
            } else {
                graphics.setColor(jComponent.getBackground());
            }
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        String string = "";
        if (keyStroke != null) {
            int n2 = keyStroke.getModifiers();
            if (n2 > 0) {
                string = KeyEvent.getKeyModifiersText(n2);
                string = String.valueOf(string) + "+";
            }
            string = String.valueOf(string) + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        String string2 = BasicGraphicsUtils.layoutMenuItem((FontMetrics)fontMetrics, (String)jMenuItem.getText(), (FontMetrics)fontMetrics2, (String)string, (Icon)jMenuItem.getIcon(), (Icon)icon, (Icon)icon2, (int)jMenuItem.getVerticalAlignment(), (int)jMenuItem.getHorizontalAlignment(), (int)jMenuItem.getVerticalTextPosition(), (int)jMenuItem.getHorizontalTextPosition(), (Rectangle)rectangle, (Rectangle)rectangle2, (Rectangle)rectangle3, (Rectangle)rectangle4, (Rectangle)rectangle5, (Rectangle)rectangle6, (int)(jMenuItem.getText() == null ? 0 : n), (int)n);
        Color color3 = graphics.getColor();
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            icon.paintIcon((Component)jComponent, graphics, rectangle5.x, rectangle5.y);
            graphics.setColor(color3);
        }
        if (jMenuItem.getIcon() != null) {
            Icon icon3;
            if (!buttonModel.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            icon3.paintIcon((Component)jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (string2 != null && !string2.equals("")) {
            if (!buttonModel.isEnabled()) {
                graphics.setColor(jMenuItem.getBackground().brighter());
                BasicGraphicsUtils.drawString((Graphics)graphics, (String)string2, (int)buttonModel.getMnemonic(), (int)rectangle3.x, (int)(rectangle3.y + fontMetrics.getAscent()));
                graphics.setColor(jMenuItem.getBackground().darker());
                BasicGraphicsUtils.drawString((Graphics)graphics, (String)string2, (int)buttonModel.getMnemonic(), (int)(rectangle3.x - 1), (int)(rectangle3.y + fontMetrics.getAscent() - 1));
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
                BasicGraphicsUtils.drawString((Graphics)graphics, (String)string2, (int)buttonModel.getMnemonic(), (int)rectangle3.x, (int)(rectangle3.y + fontMetrics.getAscent()));
            }
        }
        if (string != null && !string.equals("")) {
            graphics.setFont(UIManager.getFont((Object)"MenuItem.acceleratorFont"));
            if (!buttonModel.isEnabled()) {
                graphics.setColor(jMenuItem.getBackground().brighter());
                BasicGraphicsUtils.drawString((Graphics)graphics, (String)string, (int)buttonModel.getMnemonic(), (int)rectangle4.x, (int)(rectangle4.y + fontMetrics.getAscent()));
                graphics.setColor(jMenuItem.getBackground().darker());
                BasicGraphicsUtils.drawString((Graphics)graphics, (String)string, (int)buttonModel.getMnemonic(), (int)(rectangle4.x - 1), (int)(rectangle4.y + fontMetrics.getAscent() - 1));
            } else {
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(color2);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
                BasicGraphicsUtils.drawString((Graphics)graphics, (String)string, (int)buttonModel.getMnemonic(), (int)rectangle4.x, (int)(rectangle4.y + fontMetrics.getAscent()));
            }
        }
        if (icon2 != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color2);
            }
            if (!(jMenuItem.getParent() instanceof JMenuBar)) {
                icon2.paintIcon((Component)jComponent, graphics, rectangle6.x, rectangle6.y);
            }
        }
        graphics.setColor(color3);
        graphics.setFont(font);
    }

    private static void drawMenuBezel(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color.brighter().brighter());
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + 1);
        graphics.setColor(color.darker().darker());
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 2);
    }
}

